/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.sigil;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.BlockWrapper;
import wayoftime.bloodmagic.common.item.sigil.ItemSigilBase;

public abstract class ItemSigilFluidBase
extends ItemSigilBase {
    public final FluidStack sigilFluid;

    public ItemSigilFluidBase(String name, int lpUsed, FluidStack fluid) {
        super(name, lpUsed);
        this.sigilFluid = fluid;
    }

    public ItemSigilFluidBase(String name, FluidStack fluid) {
        super(name);
        this.sigilFluid = fluid;
    }

    public ItemSigilFluidBase(String name) {
        super(name);
        this.sigilFluid = null;
    }

    @Nullable
    protected IFluidHandler getFluidHandler(Level world, BlockPos blockPos, @Nullable Direction side) {
        BlockState state = world.m_8055_(blockPos);
        Block block = state.m_60734_();
        IFluidHandler targetFluidHandler = (IFluidHandler)FluidUtil.getFluidHandler((Level)world, (BlockPos)blockPos, (Direction)side).orElse(null);
        if (targetFluidHandler == null) {
            // empty if block
        }
        return targetFluidHandler;
    }

    protected boolean tryInsertSigilFluid(IFluidHandler destination, boolean doTransfer) {
        if (destination == null) {
            return false;
        }
        return destination.fill(this.sigilFluid, doTransfer ? IFluidHandler.FluidAction.EXECUTE : IFluidHandler.FluidAction.SIMULATE) > 0;
    }

    protected boolean tryRemoveFluid(IFluidHandler source, int amount, boolean doTransfer) {
        if (source == null) {
            return false;
        }
        return source.drain(amount, doTransfer ? IFluidHandler.FluidAction.EXECUTE : IFluidHandler.FluidAction.SIMULATE) != null;
    }

    protected boolean tryPlaceSigilFluid(Player player, Level world, BlockPos blockPos) {
        FluidStack resource = this.sigilFluid;
        BlockState state = this.sigilFluid.getFluid().getAttributes().getBlock((BlockAndTintGetter)world, blockPos, this.sigilFluid.getFluid().m_76145_());
        BlockWrapper wrapper = new BlockWrapper(state, world, blockPos);
        if (world.m_6042_().m_63951_() && resource.getFluid().getAttributes().doesVaporize((BlockAndTintGetter)world, blockPos, resource)) {
            resource.getFluid().getAttributes().vaporize(player, world, blockPos, resource);
            return true;
        }
        return wrapper.fill(this.sigilFluid, IFluidHandler.FluidAction.EXECUTE) > 0;
    }
}

